from machine import Pin, ADC
import neopixel
import time

# Potentiometer (GP26)
potentiometer = ADC(26)

# NeoPixel LED Ring (GPI15)
NUM_LEDS = 16
np = neopixel.NeoPixel(Pin(15), NUM_LEDS)

while True:
    pot_value = potentiometer.read_u16()

    if pot_value < 3000:
        brightness = 0
    else:
        brightness = pot_value // 256

    for i in range(NUM_LEDS):
        np[i] = (brightness, brightness, brightness)

    np.write()
    time.sleep(0.05)
